#ifndef __SORTEDMSGQUEUE_H__
#define __SORTEDMSGQUEUE_H__

#include "Util/cCriticalSection.h"

struct MsgInfo;
class cPbcastNode;

// Queue exception class.
class cQueueException { 

 public: 
	cQueueException(char *buf)
	{
		strncpy(mString, buf, 127);
		mString[127] = '\0';
	}
	~cQueueException() { ; }

	char *ToString()
	{
		return mString;
	}
 private:
	char	mString[128];
};

class cSortedMsgQueue
{

 protected:

 public:
		
	//Constructor(s)
	cSortedMsgQueue(unsigned int size, DWORD msgTimeout, unsigned int capIncrement=64);	

	//Destructor
	~cSortedMsgQueue();

	//Public Functions
	bool	Clear();				// Clears the queue.
	int		GetNumElements()  { return mNumElements; }

	bool	Compact();		// Compacts the message queue.

	bool	Clear(cPbcastNode* node);	// Removes all of that node's messages.
	bool	Insert(MsgInfo msg);
	bool	Replace(MsgInfo* searchMsg);
	bool	Find(MsgInfo* searchMsg);
	
	void	Lock()  { mCS.Enter(); }// Lock this data structure.
	void	Unlock(){ mCS.Leave(); }// Unlocks this data structure.

	void	SetCleanupTime(DWORD newTime) { mMsgTimeout = newTime; }

 private:
	bool _Replace(MsgInfo* info, unsigned int location);
	int	 _BinSearch(MsgInfo* searchMsg, unsigned int left, unsigned int right);
	bool _Before(MsgInfo* a, MsgInfo* b);
	bool _Equal(MsgInfo* a, MsgInfo* b);
	bool _InsertSort();
	bool _Grow();		// Attempts to grow the queue by at least one element, at most mCapIncrement

	// Mutex
	cCriticalSection	mCS;

	//Member Vars
	DWORD		 mMsgTimeout;	// Time after which msgs may be kicked out of the buffer.
	MsgInfo		*mQueue;
	unsigned int mInsertPtr;
	unsigned int mRemovePtr;
	unsigned int mSize;
	unsigned int mNumElements;
	unsigned int mCapIncrement;
};

#endif
